﻿using System;
using System.Collections.Generic;
using HIPS.PcehrSchemas;
using HIPS.Web.Components.Cache;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.ModelInterface.AssistedRegistration
{
    public class CachedPatientsWithoutPcehrRepository : IPatientsWithoutPcehrRepository
    {
        private IPatientsWithoutPcehrRepository ReferenceRepository { get; set; }
        private ICacheProvider CacheProvider { get; set; }
        private readonly string CacheKeyFormat;

        public CachedPatientsWithoutPcehrRepository(
            IPatientsWithoutPcehrRepository referenceRepository, ICacheProvider cacheProvider, string cacheKeyPrefix = "")
        {
            ReferenceRepository = referenceRepository;
            CacheProvider = cacheProvider;
            CacheKeyFormat = cacheKeyPrefix + ".CachedPatientsWithoutPcehrRepository.{0}";
        }

        public PatientWithoutPcehrResponse ListPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode = null)
        {
            string cacheKeyValue = String.Format("ListPatientsWithoutPcehr(HospitalCodeSystem: {0}, HospitalCode: {1})",
                                                 hospitalCodeSystem,
                                                 hospitalCode);

            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, cacheKeyValue),
                                     () => ReferenceRepository.ListPatientsWithoutPcehr(hospitalCodeSystem, hospitalCode));
        }

        // TODO: Refactor remove
        public List<ValidatedPatient> GetPatientsWithoutPcehr(string hospitalCodeSystem, List<Sex> sexes)
        {
            string cacheKeyValue = String.Format("GetPatientsWithoutPcehr(HospitalCodeSystem: {0}, Sexes: (Collection))",
                                                hospitalCodeSystem);

            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, cacheKeyValue),
                                     () => ReferenceRepository.GetPatientsWithoutPcehr(hospitalCodeSystem, sexes));
        }

        // TODO: Refactor remove
        public List<ValidatedPatient> GetPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode, List<Sex> sexes)
        {
            string cacheKeyValue = String.Format("GetPatientsWithoutPcehr(HospitalCodeSystem: {0}, HospitalCode: {1}, Sexes: (Collection))",
                                                hospitalCodeSystem,
                                                hospitalCode);

            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, cacheKeyValue),
                                     () => ReferenceRepository.GetPatientsWithoutPcehr(hospitalCodeSystem, hospitalCode, sexes));
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (ReferenceRepository != null)
            {
                ReferenceRepository.Dispose();
                ReferenceRepository = null;
            }
        }
    }
}